dofile("scripts/LevelManager.lua");

LManager = LevelManager.create();

LManager:AddNewTable( 1, 2, 300, 220, "assets/images/table/island_2", "assets/images/food/item_mark1", "R" );
LManager:AddNewTable( 2, 3, 200, 350, "assets/images/table/island", "assets/images/food/item_mark2", "R" );
LManager:AddNewTable( 3, 2, 420, 350, "assets/images/table/island_2", "assets/images/food/item_mark3", "R" );
LManager:AddNewTable( 4, 6, 240, 485, "assets/images/table/island_6", "assets/images/food/item_mark4", "B" );


useFloAsServer = 0;
useWineTable = 1;
numMoodBoosts = 2;
numServers = 1;
maxCoupleHappiness = 400;

-- Group 1

guest = LManager.GenGuest(male03);
guest.matchType = table3;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female03);
guest.matchType = NOT_TABLE + table4;
guest.likes={female01};
LManager:AddGuest(guest);

guest = LManager.GenGuest(female01);
guest.matchType = NOT_TABLE + table1;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female02);
guest.matchType = female01;
guest.likes={male03};
LManager:AddGuest(guest);

guest = LManager.GenGuest(male01);
guest.matchType = table1;
guest.percentRequestDrink = 50;
LManager:AddGuest(guest);


LManager:SetSeatingGroup(1, 5, 3000);


-- Group 2


guest = LManager.GenGuest(uncle);
guest.matchType = aunt;
guest.percentRequestDrink = 50;
LManager:AddGuest(guest);

guest = LManager.GenGuest(aunt);
guest.matchType = NOT_GUEST + female01;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female02);
guest.matchType = female03;
guest.likes={male01};
LManager:AddGuest(guest);

guest = LManager.GenGuest(female02);
guest.matchType = female03;
guest.likes={male01};
LManager:AddGuest(guest);

LManager:SetSeatingGroup(6, 9, 26000);


-- Group 3

guest = LManager.GenGuest(aunt);
guest.matchType = female01;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male04);
guest.matchType = NOT_GUEST + female02;
guest.percentRequestMusic = 50;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female04);
guest.matchType = male04;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(10, 12, 60000);

-- Group 4

guest = LManager.GenGuest(female01);
guest.matchType = table1;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(13, 13, 80000);

-- Group 5

guest = LManager.GenGuest(male02);
guest.matchType = female04;
guest.percentRequestMusic = 50;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female04);
guest.matchType = table4;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female03);
guest.matchType = female04;
LManager:AddGuest(guest);


LManager:SetSeatingGroup(14, 16, 130000);

-- Group 6

guest = LManager.GenGuest(male03);
guest.matchType = female03;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male01);
guest.matchType = NOT_GUEST + male02;
guest.percentRequestMusic = 50;
LManager:AddGuest(guest);

guest = LManager.GenGuest(uncle);
guest.matchType = male01;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female02);
guest.matchType = table2;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(17, 20, 150000);





LManager:AdjustGuestTolerance(130);


LManager:SetLevelSetting ("speakerDelay", 160000); 
LManager:SetLevelSetting ("speakerChance", 40);


LManager:AddQuinnEvent( "fx/fx_chef_table_fire.lua", 660, 155, 140000 );

LManager:SetLevelSetting ("bridesmaidsDelay", 90000); 
LManager:SetLevelSetting ("bridesmaidsChance", 100);

LManager:AddReseatingRequestForGuest(50000, female03);
LManager:AddReseatingRequestForGuest(65000, female02);
LManager:AddReseatingRequestForGuest(80000, male02);
LManager:AddReseatingRequestForGuest(100000, female04);

-- Set up the Level Settings
LManager:SetLevelNumber(4,9);
LManager:SetLevelScores(8500, 11000);
LManager:SetLevelTime(300000);
LManager:SetLevelSetting ("blaster", 1);

LManager:SetMusic("assets/audio/music/Big Band 4.ogg","assets/audio/music/Uptempo 1.ogg","assets/audio/music/Disco Dance 1.ogg");
LManager:SetBackgroundImage("assets/images/bg_island");
LManager:SetChairImage("assets/images/table/chair04");

-- Generate Game Object
gameObject = LManager:GenerateGameObject();

-- Generate Level Settings
levelSetting = LManager:GenerateLevelSettings();

-- Generate Level Dialog
dofile( "scripts/LevelDialogGenerator.lua" );